//GridBagFrame.java
// Baada 24 jan
// Jonas 28 jan
// Jonas 30 jan
// Jonas 12 feb
// Jonas 13 feb
// Jonas 16 feb
import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

import Globals;
import Agent;
import MobileHost;

public class GridBagFrame extends Frame implements ActionListener, ItemListener {
  public MobileIP mobile;
  public FontTextArea textArea1;
  public ShowMobileIPCanvas IPCanvas;
  int height, width;
  Button b1, b2;
  MenuBar mb;
  Menu m1, m2, mh;
  MenuItem mi11, mih1, mih2; 
  CheckboxMenuItem mi21, mi22, mi23;
  
  // Constructor for GridBagFrame
  public GridBagFrame(int width, int height, MobileIP father) {
    super("GridBagFrame");
    this.width = width;
    this.height = height;
    this.mobile = father;

    // Always use setBounds()?
    setBounds(400, 500, width, height);
  
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    
    setFont(new Font("Helvetica", Font.PLAIN, 14));
    setLayout(gridbag);
    
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0;
    
    // Build MenuBar
    mb = new MenuBar();
    setMenuBar(mb);
       
    // Add MenuItems in Menu Applet
    m1 = new Menu("Applet", false);
    mb.add(m1);
    mi11 = new MenuItem("Exit");
    m1.add(mi11);
    
    // Speed Menu
    m2 = new Menu("Speed", false);
    mb.add(m2);
    mi21 = new CheckboxMenuItem("Slow", false);
    mi21.setEnabled(true);
    m2.add(mi21);
    mi22 = new CheckboxMenuItem("Medium", true);
    mi22.setEnabled(true);
    m2.add(mi22);
    mi23 = new CheckboxMenuItem("Fast", false);
    mi23.setEnabled(true);
    m2.add(mi23);
        
    // HelpMenu
    mh = new Menu("Help", false);
    mb.add(mh);  
    mb.setHelpMenu(mh);
    mih1 = new MenuItem("Help(Browser)");
    mh.add(mih1);
    mih2 = new MenuItem("About(Browser)");
    mh.add(mih2);
    
    // Add menuActionCommands
    mi11.setActionCommand("AppletExit");
    
    // Add ActionListeners
    m1.addActionListener(this);
    mi21.addItemListener(this);
    mi22.addItemListener(this);
    mi23.addItemListener(this);
    mh.addActionListener(this);
      
    // Add buttons 
    b1 = new Button("Continue");
    gridbag.setConstraints(b1, c);  
    b1.setEnabled(false); 
    b1.addActionListener(this);
    add(b1);
    b2 = new Button("STOP");
    gridbag.setConstraints(b2, c);
    b2.setEnabled(false);
    b2.addActionListener(this);
    add(b2);
        
    // A dividing line to the right of the buttons
    Canvas DivideLine = new Canvas();
    DivideLine.setBackground(Color.darkGray);
    DivideLine.setSize(4,680);
    c.gridheight = 2;
    c.gridwidth = 1;
    c.weightx = 0;
    c.weighty = 1;
 
    gridbag.setConstraints(DivideLine, c);
    add(DivideLine);
    
    //A TextArea right of the buttons
    String textString ="Welcome to MobileIP World!\n";
    textArea1 = new FontTextArea(10, 10, 
				FontTextArea.SCROLLBARS_VERTICAL_ONLY );
    textArea1.setEditable(false);
    textArea1.setBackground(Color.white);
    c.gridwidth = GridBagConstraints.REMAINDER; //End of row
    c.gridheight = 2;
    c.ipadx = 0;         // Reset to default
    c.weighty = 1.0;
    c.weightx = 1.0;
    gridbag.setConstraints(textArea1, c);
    add(textArea1);
    
    //The ShowMobileIPCanvas object under the buttons
    IPCanvas = new ShowMobileIPCanvas(150, 200, this);
    IPCanvas.setBackground(Color.lightGray);
    c.gridy = 1;
    c.gridx = 0;
    c.gridwidth = GridBagConstraints.RELATIVE;
    c.weighty = 0.0;
    c.gridheight = 1;
    gridbag.setConstraints(IPCanvas, c);
    add(IPCanvas);

    //Show the GridBagFrame
    this.show();
    // Print Welcome message
    textArea1.append(textString);
    
  }

   // Define the minimum size of the GridBagFrame
  public Dimension getMinimumSize() {
    return(new Dimension(width, height)); 
  }
  
  // ActionListener
  public void actionPerformed(ActionEvent e) {
   
    Object source = e.getSource();
    if (e.getActionCommand()=="AppletExit") 
      dispose();
    if (source == b1) {              
      setCont();
      switch (Globals.whichThread) {
      case 1:  
	IPCanvas.t.L.closeLetterDialog(); 
	IPCanvas.t.resume(); 
	break;
      case 2:
	for (int i=0; i<IPCanvas.nbrOfNotifyThreads; i++){
	  IPCanvas.t2[i].L.closeLetterDialog();     
	  IPCanvas.t2[i].resume();
	}
	break;
      case 3: 
	IPCanvas.t3.L.closeLetterDialog();     
	IPCanvas.t3.resume();
	break; 
      case 4: 
	IPCanvas.t4.L.closeLetterDialog();     
	IPCanvas.t4.resume();
	break;
      case 5: 
	IPCanvas.t5.L.closeLetterDialog();     
	IPCanvas.t5.resume();
	break;
      case 6: 
	IPCanvas.t6.P.closePackageDialog();     
	IPCanvas.t6.resume();
	break;
      case 7:
	IPCanvas.t7.L.closeLetterDialog();     
	IPCanvas.t7.resume();
	break;
      case 8:
	IPCanvas.t8.L.closeLetterDialog();
	IPCanvas.t8.resume();
	break;
      }
    } 
    else if (source == b2) // Stop button
      Globals.contAllowed = false;
    else if (source == mih1)   // Help-help menuItem
      mobile.getAppletContext().showDocument(Globals.userURL);
    else if (source == mih2)   // Help-about menuItem
      mobile.getAppletContext().showDocument(Globals.aboutURL);
    
  }  
  // ItemListener for the CheckBoxMenuItems
  public void itemStateChanged(ItemEvent e) {
    Object source = e.getItemSelectable();
    if (source == mi21) {
      Globals.sleepTime = 30;
      Globals.pauseTime = 3000;
      mi22.setState(false);
      mi23.setState(false);
    }
    else if (source == mi22) {
      Globals.sleepTime = 15;
      Globals.pauseTime = 2000;
      mi21.setState(false);
      mi23.setState(false);
    }
    else if (source == mi23){
      Globals.sleepTime = 7;
      Globals.pauseTime = 1000;
      mi21.setState(false);
      mi22.setState(false);
    }
    else {}
  }
    
  
  // Method to make the Frame closeable. JAVA 1.0
  public boolean handleEvent(Event e) {
    switch (e.id) {
    case Event.WINDOW_DESTROY:
      dispose();
      return true;
    default:
      return super.handleEvent(e);
    }
  }

  // Continue control
  public void setStop() {
    b1.setEnabled(true);
    b2.setEnabled(false);
    Globals.contAllowed = false;
  }
  public void setCont() {
    b1.setEnabled(false);
    b2.setEnabled(true);
    Globals.contAllowed = true;
  }
  public void setDisabled() {
    b1.setEnabled(false);
    b2.setEnabled(false);
  }
}
